ORCA/M Asm65816 2.1.0

0001 C400                       TITLE 'Phoenix Mouse $Cn00 Space.'
0002 C400
0003 C400              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 C400              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 9:29:34 PM
0005 C400
0006 C400              ********************************************************
0007 C400              *                                                      *
0008 C400              *                    Phoenix  Mouse                    *
0009 C400              *                                                      *
0010 C400              *                      $C400 Space                     *
0011 C400              *                                                      *
0012 C400              *                          by                          *
0013 C400              *                     Fern Bachman                     *
0014 C400              *                     Joe  Bo                          *
0015 C400              *                                                      *
0016 C400              *      Copyright  1984-1989 by Apple Computer, Inc.    *
0017 C400              *                 All Rights Reserved                  *
0018 C400              *                                                      *
0019 C400              ********************************************************
0020 C400
0021 C400
0022 C400              * The slot 4 and related bank $ff mouse firmware have been 
0023 C400              * changed so that it calls mouse tools (in miscellaneous tools)
0024 C400              * to set or get the necessary information.
0025 C400              * To use slot 4 as an entry (most P8 applications), select slot 4
0026 C400              * to be Mouse Port in the control panel.
0027 C400              * For new gs applications, it is not necessary to set slot 4 as
0028 C400              * Mouse Port and therefore can free up a slot for 'Your Card'.
0029 C400              * For slot 4 mouse firmware and mouse tools to work properly, 
0030 C400              * separate mouse parameters location have been defined in slot 4
0031 C400              * screen holes and bank $e1.  When slot 4 mouse firmware gets called
0032 C400              * then the related screen holes parameters would show up also in 
0033 C400              * the bank $e1 mouse locations but not vice versa.  Slot 4 and 
0034 C400              * bank $ff mouse firmware relies on mouse tools.
0035 C400              * 
0036 C400              * Mouse parameters:
0037 C400              *  Descriptions                 slot 4       bank $e1
0038 C400              *------------------------------------------------------------
0039 C400              * Low byte of abs X             $047c        $e10190
0040 C400              * Low byte of abs Y             $04fc        $e10191
0041 C400              * High byte of abs X            $057c        $e10192
0042 C400              * High byte of abs Y            $05fc        $e10193
0043 C400              * Info, bits 6, 7 for Y clamps  $067c        $e10194
0044 C400              * Spare, reserved as a temp     $06fc        $e10195
0045 C400              * Button                        $077c        $e10196
0046 C400              * Mousmode                      $07fc        $e10197
0047 C400              *   
0048 C400
0049 C400
0050 C400              * BASICSTART EQU *
0051 C400 80 05                 BRA   OENTBAS                  ;Branch always
0052 C402 C6 C1 C2              DC B:$C6,$C1,$C2               ;
0053 C405              IENTBAS  EQU   *                        ;Basic input entry point
0054 C405 38                    SEC                            ;Must=$38 for IN# in Basic
0055 C406 90                    OPCODE BCC                     ;Causes skip over CLC instruction
0056 C407              OENTBAS  EQU   *                        ;Basic output entry point
0057 C407 18                    CLC                            ;Must=$18 for PR# in Basic
0058 C408 80 16                 BRA   @1                       ;Go to basic entry point 
0059 C40A EA                    NOP                            ;Required filler
0060 C40B 01                    DC B:$01                       ;PASCAL generic sig byte
0061 C40C 20                    DC B:$20                       ;Dev sig//Apple tech supp id
0062 C40D 72                    DC B:PERROR                    ;Offset to PASCAL PINIT
0063 C40E 72                    DC B:PERROR                    ;Offset to PASCAL PREAD
0064 C40F 72                    DC B:PERROR                    ;Offset to PASCAL PWRITE
0065 C410 72                    DC B:PERROR                    ;Offset to PASCAL PSTATUS
0066 C411 00                    DC B:00                        ;Must be 00
0067 C412 60                    DC B:TSETMOUSE                 ;Offset to SETMOUSE
0068 C413 29                    DC B:SERVEMOUSE                ;Offset to SERVEMOUSE
0069 C414 A6                    DC B:TREADMOUSE                ;Offset to TREADMOUSE
0070 C415 7B                    DC B:CLEARMOUSE                ;Offset to CLEARMOUSE 
0071 C416 99                    DC B:POSMOUSE                  ;Offset to POSMOUSE
0072 C417 A1                    DC B:TCLAMPMOUSE               ;Offset to TCLAMPMOUSE 
0073 C418 E0                    DC B:THOMEMOUSE                ;Offset to THOMEMOUSE
0074 C419 76                    DC B:TINITMOUSE                ;Offset to TINITMOUSE
0075 C41A 9F                    DC B:CLRCRTS                   ;Dummy offset to DIAGMOUSE
0076 C41B 9F                    DC B:CLRCRTS                   ;Dummy offset to COPYRIGHT
0077 C41C 9F                    DC B:CLRCRTS                   ;Dummy offset to TIMEDATA
0078 C41D 9F                    DC B:CLRCRTS                   ;Dummy offset to SETVBLCNTS
0079 C41E 9F                    DC B:CLRCRTS                   ;Dummy offset to OPTMOUSE
0080 C41F 9F                    DC B:CLRCRTS                   ;Dummy offset to STARTTIMER
0081 C420
0082 C420              @1       EQU   *
0083 C420 5A                    PHY                            ;Save Y on stack
0084 C421 9B                    TXY                            ;Save 'X' value in 'Y' register
0085 C422 A2 06                 LDX   #$06                     ;Indicate which mouse routine to do
0086 C424 20 A8 C4              JSR   GODOMOUSE                ;Go do the mouse routine requested
0087 C427 7A                    PLY                            ;Restore former Y
0088 C428 60                    RTS                            ;Back to BASIC
0089 C429
0090 C429              SERVEMOUSE EQU   *                      ;User entry point - SERVEMOUSE 
0091 C429 A9 0E                 LDA   #$0E                     ;Reset bits 1,2,3
0092 C42B 1C 7C 07              TRB   BUTTON                   ;Causes reset of bits 1,2,3
0093 C42E AF C3 00 E1           LDA   >IRQ_INTFLAG             ;Test VBL enabled/active status flag
0094 C432 A8                    TAY                            ;Save temporarily
0095 C433 29 08                 AND   #$08                     ;Bit 3 = status
0096 C435 F0 0C                 BEQ   @1                       ;Not VBL int then don't reset it
0097 C437 8D 47 C0              STA   CLRVBLINT                ;Disable VBL interrupt
0098 C43A 98                    TYA                            ;Reset VBL interrupt status bit
0099 C43B 29 F7                 AND   #$F7                     ;Clears bit
0100 C43D 8F C3 00 E1           STA   >IRQ_INTFLAG             ;Save status
0101 C441 A9 08                 LDA   #$08                     ;Bit to set in BUTTON
0102 C443              @1       EQU   *
0103 C443 A8                    TAY                            ;Save status
0104 C444 0C 7C 07              TSB   BUTTON                   ;Set VBL bit if active
0105 C447 2C 27 C0              BIT   KMSTATUS                 ;Check for mouse info
0106 C44A 50 08                 BVC   @2                       ;Mouse interrupts not enabled
0107 C44C 10 06                 BPL   @2                       ;Interrupts enabled but mouse didn't int
0108 C44E A9 0E                 LDA   #$E                      ;What's interrupt status?
0109 C450 A8                    TAY                            ;Set 'Y' non-zero
0110 C451 0C 7C 07              TSB   BUTTON                   ;Combine in with button status
0111 C454
0112 C454              @2       EQU   *
0113 C454 AD 7C 07              LDA   BUTTON                   ;Get mouse button status from screen holes
0114 C457 8F 96 01 E1           STA   MSESTAT                  ;Update related location in bank $e1
0115 C45B 98                    TYA                            ;Test if mousey interrupt or not
0116 C45C F0 16                 BEQ   PERROR2                  ;'c'=1 exit for not mousey type interrupt
0117 C45E 18                    CLC                            ;<> 0 so RTS with C=0
0118 C45F 60                    RTS                            ;Back to caller
0119 C460
0120 C460              TSETMOUSE EQU   *                       ;Mode is in A upon entry 
0121 C460 C9 10                 CMP   #$10                     ;If $10 or > then error
0122 C462 B0 10                 BCS   PERROR2                  ;Set carry for error exit
0123 C464 A2 0A                 LDX   #$0A                     ;Indicate which mouse routine to do
0124 C466 20 A8 C4              JSR   GODOMOUSE                ;
0125 C469 AF 97 01 E1           LDA   >MSEMODE                 ;Get from bank $e1 mouse mode byte
0126 C46D 8D FC 07              STA   MOUSMODE                 ; and update the screen hole also
0127 C470 18                    CLC                            ;Must exit w/ carry clear
0128 C471 60                    RTS   
0129 C472
0130 C472              * PASCAL PREAD, PWRITE, PSTATUS, PINIT are not
0131 C472              * supportted by the mouse except to generate
0132 C472              * an error for the PASCAL programmer.
0133 C472
0134 C472              PERROR   EQU   *
0135 C472 A2 03                 LDX   #$03                     ;Bad mode : illegal operation
0136 C474              PERROR2  EQU   *
0137 C474 38                    SEC                            ;Must set C before exiting
0138 C475 60                    RTS                            ;Back to caller
0139 C476
0140 C476              TINITMOUSE EQU   *                      ;User entry point - INITMOUSE 
0141 C476 A2 00                 LDX   #$00                     ;Indicate which mouse routine to do
0142 C478 20 A8 C4              JSR   GODOMOUSE                ;
0143 C47B
0144 C47B              CLEARMOUSE EQU   *                      ;User entry point - CLEARMOUSE
0145 C47B 9C 7C 05              STZ   HI                       ;Clear screen holes
0146 C47E 9C 7C 04              STZ   LO                       ;
0147 C481 9C FC 05              STZ   HI+$80                   ;
0148 C484 9C FC 04              STZ   LO+$80                   ;
0149 C487 9C 7C 07              STZ   BUTTON                   ;
0150 C48A A2 03                 LDX   #$03                     ;Also clear related bank $e1 mouse stuff
0151 C48C A9 00                 LDA   #$00                     ;
0152 C48E              @1       EQU   *
0153 C48E 9F 90 01 E1           STA   >LowAbsx,X               ;
0154 C492 CA                    DEX                            ;
0155 C493 10 F9                 BPL   @1                       ;Loop till done
0156 C495 8F 96 01 E1           STA   >MseStat                 ;Clear mouse status byte also
0157 C499
0158 C499              POSMOUSE EQU   *                        ;User entry point - POSMOUSE
0159 C499 08                    PHP                            ;No interrupts in GETMDATA
0160 C49A 78                    SEI                            ;
0161 C49B 20 C6 C4              JSR   GETMDATA                 ;Reset KeyGlu mouse information
0162 C49E 28                    PLP                            ;Restore interrupt status
0163 C49F              CLRCRTS  EQU   *
0164 C49F 18                    CLC                            ;Must exit with carry clear
0165 C4A0 60                    RTS                            ;Back to caller
0166 C4A1
0167 C4A1
0168 C4A1              TCLAMPMOUSE EQU   *                     ;User entry point - CLAMPMOUSE
0169 C4A1 A2 02                 LDX   #$02                     ;Indicate which mouse routine to do
0170 C4A3 20 A8 C4              JSR   GODOMOUSE                ;
0171 C4A6
0172 C4A6              TREADMOUSE EQU   *                      ;User entry point - READMOUSE 
0173 C4A6 A2 04                 LDX   #$04                     ;Indicate which mouse routine to do
0174 C4A8
0175 C4A8              GODOMOUSE EQU   *
0176 C4A8 08                    PHP                            ;Must save c/v statuses
0177 C4A9 18                    CLC                            ;Off to native mode
0178 C4AA FB                    XCE                            ;
0179 C4AB 28                    PLP                            ;Restore c/v statuses
0180 C4AC EB                    XBA                            ;Don't alter 'A'
0181 C4AD AD 36 C0              LDA   CYAREG                   ;What's current speed?
0182 C4B0 48                    PHA                            ;Save for later restoring
0183 C4B1 09 80                 ORA   #$80                     ;Let's do hi speed
0184 C4B3 8D 36 C0              STA   CYAREG                   ;
0185 C4B6 EB                    XBA                            ;Don't forget to restore 'A' value
0186 C4B7 22 08 77 FF           JSL   >MOUSE_DISPATCHER        ;Off to bank FF
0187 C4BB 08                    PHP                            ;Save c status
0188 C4BC 38                    SEC                            ;Back to emulation mode
0189 C4BD FB                    XCE                            ;
0190 C4BE 28                    PLP                            ;Restore c status
0191 C4BF EB                    XBA                            ;Don't loose 'A'
0192 C4C0 68                    PLA                            ;Recall user entry speed
0193 C4C1 8D 36 C0              STA   CYAREG                   ; and restore it.
0194 C4C4 EB                    XBA                            ;Got back 'A'
0195 C4C5 60                    RTS                            ;Back to caller of this subroutine
0196 C4C6
0197 C4C6
0198 C4C6              *
0199 C4C6              * GETMDATA returns three things
0200 C4C6              *
0201 C4C6              *   If C=0 then the following is true
0202 C4C6              *      X = X / butn1 information
0203 C4C6              *          bit 7= butn 1 status
0204 C4C6              *          bit 6= sign of delta
0205 C4C6              *          bits 0-5 = actual X delta movement if any
0206 C4C6              *      Y = Y / butn0 information
0207 C4C6              *          bit 7= butn 0 status
0208 C4C6              *          bit 6= sign of delta
0209 C4C6              *          bits 0-5 = actual Y delta movement if any
0210 C4C6              *
0211 C4C6              *   If C=0 then the following is true
0212 C4C6              *      Data was either unavailable or contaminated
0213 C4C6              *
0214 C4C6              *  In either case, GETMDATA returns with the
0215 C4C6              *  X/Y information register =MOUSEDATA clear and in
0216 C4C6              *  its proper state to receive more information.
0217 C4C6
0218 C4C6              GETMDATA EQU   *
0219 C4C6 AD 27 C0              LDA   KMSTATUS                 ;Test if data available
0220 C4C9 10 A9                 BPL   PERROR2                  ;If + then no data available
0221 C4CB 6A                    ROR   A                        ;Clr C if data NOT contaminated
0222 C4CC 6A                    ROR   A                        ;Bit 1 has info
0223 C4CD AD 24 C0              LDA   MOUSEDATA                ;Bit 7=butn1\bit6=direction\bits0-5=delta
0224 C4D0 AA                    TAX                            ;
0225 C4D1 B0 A1                 BCS   PERROR2                  ;C=1 if data is contaminated
0226 C4D3 AD 27 C0              LDA   KMSTATUS                 ;Verify hardware has Y data ready
0227 C4D6 29 02                 AND   #$02                     ;'z'=0 if data available
0228 C4D8 F0 9A                 BEQ   PERROR2                  ;'z'=1 then somethings wrong
0229 C4DA AD 24 C0              LDA   MOUSEDATA                ;Bit 7=butn0\bit6=direction\bits0-5=delta
0230 C4DD A8                    TAY                            ;
0231 C4DE 18                    CLC                            ;Must exit with carry clear
0232 C4DF 60                    RTS                            ;Back to caller
0233 C4E0
0234 C4E0
0235 C4E0              THOMEMOUSE EQU   *                      ;User entry point - THOMEMOUSE
0236 C4E0 A2 08                 LDX   #$08                     ;'X'=8 for home mouse
0237 C4E2 20 A8 C4              JSR   GODOMOUSE                ;Go to bank FF to execute home mouse
0238 C4E5 80 B2                 BRA   POSMOUSE                 ;Exit via position mouse
0239 C4E7
0240 C4E7                                                      ; SEG $FF
0241 C4E7              PRINTMSG8 EQU   *                       ;For external print capability
0242 C4E7                                                      ; SEG $00
0243 C4E7 20 80 C0              JSR   PRINTMSG                 ;Print message normally
0244 C4EA 6B                    RTL                            ;Back to external caller
0245 C4EB
0246 C4EB                                                      ; SEG $FF
0247 C4EB              PRINTMSG16 EQU   *                      ;For external print capability
0248 C4EB                                                      ; SEG $00
0249 C4EB 20 85 C0              JSR   PRINTMSG2                ;Print message normally
0250 C4EE 6B                    RTL                            ;Back to external caller
0251 C4EF
0252 C4EF
0253 C4EF                       FillTo $C4FB                   ;Fill with $00 
0254 C4FB
0255 C4FB D6 C6 C1 C2           DC B:$D6,$C6,$C1,$C2           ;2nd sig byte at $CnFB 
0256 C4FF
0257 C4FF              * VERSIONNUMBER EQU *
0258 C4FF 01                    DC B:$01                       ;2nd release version#=01
0259 C500
